#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from . import helpers


class FileInfo:
    def __init__(self, filename: str, checksum: str, size: int):
        """Automatically converts the filename to a host compatible file path.

        filename is not a full path, but relative to the corresponding Database
        directory.
        """
        self._set_filename(filename)
        self._checksum: str = checksum  # md5 checksum as string
        self._size: int = size  # Size in bytes

    @property
    def filename(self) -> str:
        return self._filename

    def _set_filename(self, fname: str):
        self._filename = helpers.host_path(fname)

    @property
    def checksum(self) -> str:
        return self._checksum

    @property
    def size(self) -> int:
        return self._size

    @property
    def net_filename(self) -> str:
        return helpers.net_path(self.filename)

    def is_directory(self) -> bool:
        return not self.checksum or self.filename.endswith("\\") or self.filename.endswith("/")

    def serialize_string(self) -> str:
        return "\n".join(( self.filename, self.checksum, str(self.size) ))
